/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.toolkit.runtime.VWTrkDataField;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.property.IVWFieldChangeEventListener;
import filenet.vw.toolkit.runtime.property.VWFieldChangeEvent;
import filenet.vw.toolkit.runtime.resources.VWResource;
import java.util.Vector;

public class VWFieldsTableData {
    protected String m_name;
    protected int m_stepItemCount;
    protected int m_participantItemCount;
    protected int m_itemCount = 0;
    protected boolean m_bExpandable;
    protected boolean m_bExpanded;
    protected boolean m_bStepModified;
    protected boolean m_bParticipantModified;
    protected boolean m_bModified;
    protected boolean m_bStepView;
    protected VWTrkDataField m_stepData = null;
    protected VWTrkDataField m_participantData = null;
    protected VWTrkDataField m_data = null;
    private Vector m_fieldChangeEventListeners = new Vector();

    public VWFieldsTableData(VWTrkTestDataField vwStep, VWTrkTestDataField vwParticipant) throws Exception {
        if (vwStep == null && vwParticipant == null) {
            Exception ex = new Exception(VWResource.s_failedToCreateVWFieldsTableDataObject);
            throw ex;
        }
        if (vwStep != null) {
            this.initStepData(vwStep);
            this.setStepView(true);
            this.m_bStepModified = false;
        }
        if (vwParticipant != null) {
            this.initParticipantData(vwParticipant);
            this.setStepView(false);
            this.m_bParticipantModified = false;
        }
        this.m_bModified = false;
        this.m_bExpanded = false;
        this.m_bExpandable = this.isExpandable();
    }

    public VWFieldsTableData(VWTrkTestDataField vwData, boolean bStep) throws Exception {
        if (vwData == null) {
            Exception ex = new Exception(VWResource.s_failedToCreateVWFieldsTableDataObject);
            throw ex;
        }
        if (bStep) {
            this.initStepData(vwData);
            this.setStepView(true);
            this.m_bStepModified = false;
        } else {
            this.initParticipantData(vwData);
            this.setStepView(false);
            this.m_bParticipantModified = false;
        }
        this.m_bModified = false;
        this.m_bExpanded = false;
        this.m_bExpandable = this.isExpandable();
    }

    public VWFieldsTableData(VWTrkTestDataField vwStep) throws Exception {
        this(vwStep, true);
    }

    public void initStepData(VWTrkTestDataField vwData) throws Exception {
        this.m_stepData = new VWTrkDataField(vwData);
        this.m_stepItemCount = this.m_stepData.getSize();
    }

    public void initParticipantData(VWTrkTestDataField vwData) throws Exception {
        this.m_participantData = new VWTrkDataField(vwData);
        this.m_participantItemCount = this.m_participantData.getSize();
    }

    public boolean setStepView(boolean stepView) {
        if (stepView) {
            if (this.m_stepData != null) {
                this.m_bStepView = stepView;
                this.m_data = this.m_stepData;
                this.m_itemCount = this.m_stepItemCount;
                this.m_bParticipantModified = this.m_bModified;
                this.m_bModified = this.m_bStepModified;
            }
        } else if (this.m_participantData != null) {
            this.m_bStepView = stepView;
            this.m_data = this.m_participantData;
            this.m_itemCount = this.m_participantItemCount;
            this.m_bStepModified = this.m_bModified;
            this.m_bModified = this.m_bParticipantModified;
        }
        return this.m_bStepView;
    }

    public boolean isExpandable() {
        return this.m_data.isArray() && !this.m_data.isVariousValues();
    }

    public boolean isExpanded() {
        if (this.isExpandable()) {
            return this.m_bExpanded;
        }
        return false;
    }

    public void setExpanded(boolean bExpanded) {
        this.m_bExpanded = this.isExpandable() ? bExpanded : false;
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void setModified(boolean bModified) {
        this.m_bModified = bModified;
    }

    public void updateDataFields(Vector wobCollection) {
        if (this.m_data != null) {
            this.m_data.updateDataFields(wobCollection);
        }
    }

    public void writeDataFieldsToWorkObjects(Vector wobCollection) {
        if (this.m_data != null) {
            this.m_data.writeDataFieldsToWorkObjects(wobCollection);
        }
    }

    public void collateDataField(VWTrkTestDataField vwData) throws Exception {
        if (this.m_stepData == null) {
            this.initStepData(vwData);
        } else {
            this.m_stepData.collateDataField(vwData);
        }
    }

    public void collateDataField(Object value) {
        if (this.m_data != null) {
            this.m_data.collateDataField(value);
        }
    }

    public String getName() {
        if (this.m_data != null) {
            return this.m_data.getName();
        }
        return null;
    }

    public String getDescription() {
        if (this.m_data != null) {
            return this.m_data.getDescription();
        }
        return null;
    }

    public int getMode() {
        if (this.m_data != null) {
            return this.m_data.getMode();
        }
        return -1;
    }

    public void setMode(int mode) {
        if (this.m_data != null) {
            this.m_data.setMode(mode);
        }
    }

    public boolean isArray() {
        if (this.m_data != null) {
            return this.m_data.isArray();
        }
        return false;
    }

    public boolean isVariousValues() {
        if (this.m_data != null) {
            return this.m_data.isVariousValues();
        }
        return false;
    }

    public int getType() {
        if (this.m_data != null) {
            return this.m_data.getType();
        }
        return -1;
    }

    public Object getDisplayValue() {
        if (this.m_data != null) {
            return this.m_data.getDisplayValue();
        }
        return null;
    }

    public int getSize() {
        if (this.m_data != null) {
            return this.m_data.getSize();
        }
        return 0;
    }

    public String toString() {
        if (this.m_data != null) {
            return this.m_data.toString();
        }
        return null;
    }

    public String toString(int i) {
        if (this.m_data != null) {
            return this.m_data.toString(i);
        }
        return null;
    }

    public Object getValue() {
        if (this.m_data != null) {
            return this.m_data.getValue();
        }
        return null;
    }

    public Object getValue(int i) {
        if (this.m_data != null) {
            return this.m_data.getValue(i);
        }
        return null;
    }

    public void setValue(Object value) throws Exception {
        if (this.m_data != null) {
            this.m_data.setValue(value);
            this.fireFieldChangeEvent();
        }
    }

    public void setValue(Object value, int index) throws Exception {
        if (this.m_data != null) {
            this.m_data.setValue(value, index);
            this.fireFieldChangeEvent();
        }
    }

    public void fireFieldChangeEvent() {
        VWFieldChangeEvent event = new VWFieldChangeEvent(this, this.m_data.getType());
        for (int i = 0; i < this.m_fieldChangeEventListeners.size(); ++i) {
            ((IVWFieldChangeEventListener)this.m_fieldChangeEventListeners.elementAt(i)).fieldChanged(event);
        }
    }

    public void addFieldChangeEventListener(IVWFieldChangeEventListener listener) {
        this.m_fieldChangeEventListeners.addElement(listener);
    }

    public void removeFieldChangeEventListener(IVWFieldChangeEventListener listener) {
        this.m_fieldChangeEventListeners.removeElement(listener);
    }

    public void removeReferences() {
        Object m_name = null;
        if (this.m_stepData != null) {
            this.m_stepData.removeReferences();
            this.m_stepData = null;
        }
        if (this.m_participantData != null) {
            this.m_participantData.removeReferences();
            this.m_participantData = null;
        }
        if (this.m_data != null) {
            this.m_data.removeReferences();
            this.m_data = null;
        }
        if (this.m_fieldChangeEventListeners != null) {
            this.m_fieldChangeEventListeners.removeAllElements();
            this.m_fieldChangeEventListeners = null;
        }
    }
}

